//this file is part of eMule
//Copyright (C)2002-2007 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "PreferencesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC(CPreferencesDlg, PREF_PARENT_CLASS)

BEGIN_MESSAGE_MAP(CPreferencesDlg, PREF_PARENT_CLASS)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_SBN_SELCHANGED, OnSlideBarSelChanged) //>>> WiZaRd::SlideBar [eMule+]
END_MESSAGE_MAP()

CPreferencesDlg::CPreferencesDlg()
{
	m_psh.dwFlags &= ~PSH_HASHELP;
	m_wndGeneral.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDisplay.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndConnection.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndDirectories.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndFiles.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndStats.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndWebServer.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndTweaks.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndSecurity.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndScheduler.m_psp.dwFlags &= ~PSH_HASHELP;
	m_wndMessages.m_psp.dwFlags &= ~PSH_HASHELP;

//==> PPgTabControl [shadow2004]
	m_wndDisplay2.m_psp.dwFlags &= ~PSH_HASHELP;			//Extended
	m_wndConnection2.m_psp.dwFlags &= ~PSH_HASHELP;			//Hardlimit
	m_wndConnection3.m_psp.dwFlags &= ~PSH_HASHELP;			//V Limit
	m_wndFiles2.m_psp.dwFlags &= ~PSH_HASHELP;			//Drop
	m_wndSecurity2.m_psp.dwFlags &= ~PSH_HASHELP;			//IPFilter
//<== PPgTabControl [shadow2004]
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_wndDebug.m_psp.dwFlags &= ~PSH_HASHELP;
#endif

	EnableStackedTabs(FALSE); //>>> WiZaRd::SlideBar [eMule+]	

	//basics:
	AddPage(&m_wndGeneral);			
	AddPage(&m_wndDisplay);			
	AddPage(&m_wndConnection);
	AddPage(&m_wndServer);		
	AddPage(&m_wndDirectories);	
	AddPage(&m_wndFiles);		

	//advanced:
	AddPage(&m_wndNotify);		
	AddPage(&m_wndStats);		
	AddPage(&m_wndMessages);	
	AddPage(&m_wndSecurity);	
	AddPage(&m_wndScheduler);	
	AddPage(&m_wndWebServer);
	AddPage(&m_wndTweaks);		
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	AddPage(&m_wndDebug);              
#endif

// Add tabbed pages here
//==> PPgTabControl [shadow2004]
	AddPage(&m_wndDisplay2);         			
	StartPageDisplay	= 0;
           			
	AddPage(&m_wndConnection2);
	StartPageConnection	= 0;
	    			
	AddPage(&m_wndConnection3);
	StartPageConnection	= 0;
	      				
	AddPage(&m_wndFiles2);	
	StartPageFiles		= 0;
	
	AddPage(&m_wndSecurity2);
	StartPageSecurity	= 0;
//<<< shadow2004::Tabbed Prefs [TPT] reworked		

//>>> shadow2004::Tabbed Prefs [TPT] reworked
//	m_pPshStartPage = NULL;
	m_nActiveWnd = 0;
//<<< shadow2004::Tabbed Prefs [TPT] reworked
	m_bSaveIniFile = false;
}

CPreferencesDlg::~CPreferencesDlg()
{
	m_ImageList.DeleteImageList(); //>>> WiZaRd::SlideBar [eMule+]
}

void CPreferencesDlg::OnDestroy()
{
	PREF_PARENT_CLASS::OnDestroy();
	if (m_bSaveIniFile)
	{
		thePrefs.Save();
		m_bSaveIniFile = false;
	}
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	m_nActiveWnd = GetActiveIndex();

	if(m_nActiveWnd == PW_DISPLAY2)
		m_nActiveWnd = PW_DISPLAY;

	if(m_nActiveWnd == PW_CONNECTION2)
		m_nActiveWnd = PW_CONNECTION;

	if(m_nActiveWnd == PW_CONNECTION3)
		m_nActiveWnd = PW_CONNECTION;

	if(m_nActiveWnd == PW_FILES2)
		m_nActiveWnd = PW_FILES;

	if(m_nActiveWnd == PW_SECURITY2)
		m_nActiveWnd = PW_SECURITY;
//>>> shadow2004::Tabbed Prefs [TPT] reworked
}

BOOL CPreferencesDlg::OnInitDialog()
{
//>>> WiZaRd::SlideBar [eMule+]
	m_SlideBar.CreateEx(WS_EX_CLIENTEDGE, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(0, 0, 0, 0), this, IDC_PREFS_SLIDEBAR);
	m_SlideBar.SetImageList(&m_ImageList);
	m_SlideBar.SetHAlignCaption(DT_CENTER);

//	Sets a bold font for the group buttons
	CFont* pGroupFont = m_SlideBar.GetGroupFont();
	ASSERT_VALID(pGroupFont);
	LOGFONT logFont;
	pGroupFont->GetLogFont(&logFont);
	logFont.lfWeight *= 2;
	if (logFont.lfWeight > FW_BLACK)
		logFont.lfWeight = FW_BLACK;
	pGroupFont->DeleteObject();
	pGroupFont->CreateFontIndirect(&logFont);
	ASSERT_VALID(pGroupFont);
//<<< WiZaRd::SlideBar [eMule+]

	ASSERT( !m_bSaveIniFile );
	BOOL bResult = PREF_PARENT_CLASS::OnInitDialog();
	InitWindowStyles(this);

//>>> shadow2004::Tabbed Prefs [TPT] reworked
	SetActivePage(m_nActiveWnd);
//<<< shadow2004::Tabbed Prefs [TPT] reworked

	Localize();	

	m_SlideBar.SetFocus(); //>>> WiZaRd::SlideBar [eMule+]

	return bResult;
}

//>>> WiZaRd::SlideBar [eMule+]
LRESULT CPreferencesDlg::OnSlideBarSelChanged(WPARAM /*wParam*/, LPARAM /*lParam*/)
{
	int iCurrentGlobalSel = m_SlideBar.GetGlobalSelectedItem();

//>>> shadow2004::Tabbed Prefs [TPT] reworked
	if(iCurrentGlobalSel == PW_DISPLAY && StartPageDisplay == 1)
		iCurrentGlobalSel = PW_DISPLAY2;

	if(iCurrentGlobalSel == PW_CONNECTION && StartPageConnection == 1)
		iCurrentGlobalSel = PW_CONNECTION2;

	if(iCurrentGlobalSel == PW_CONNECTION && StartPageConnection == 2)
		iCurrentGlobalSel = PW_CONNECTION3;

	if(iCurrentGlobalSel == PW_FILES && StartPageFiles == 1)
		iCurrentGlobalSel = PW_FILES2;

	if(iCurrentGlobalSel == PW_SECURITY && StartPageSecurity == 1)
		iCurrentGlobalSel = PW_SECURITY2;
//<<< shadow2004::Tabbed Prefs [TPT] reworked

	SetActivePage(iCurrentGlobalSel);

	CListBoxST* pListBox = m_SlideBar.GetGroupListBox(m_SlideBar.GetSelectedGroupIndex());
	ASSERT_VALID(pListBox);

	CString strCurrentItemText;
	pListBox->GetText(pListBox->GetCurSel(), strCurrentItemText);

	CString strCurrentGroupText = m_SlideBar.GetGroupName(m_SlideBar.GetSelectedGroupIndex());
	strCurrentGroupText.Remove('&');

	CString strTitle = RemoveAmbersand(GetResString(IDS_EM_PREFS));
	SetWindowText(strTitle + _T(" -> ") + strCurrentGroupText + _T(" -> ") + strCurrentItemText);

	pListBox->SetFocus();

	return TRUE;
}
//<<< WiZaRd::SlideBar [eMule+]

void CPreferencesDlg::Localize()
{
//>>> WiZaRd::SlideBar [eMule+]
	m_ImageList.DeleteImageList();
	m_ImageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 0, 1);
	//basics:
	m_ImageList.Add(CTempIconLoader(_T("PREFERENCES")));
	m_ImageList.Add(CTempIconLoader(_T("DISPLAY")));
	m_ImageList.Add(CTempIconLoader(_T("CONNECTION")));
	m_ImageList.Add(CTempIconLoader(_T("SERVER")));
	m_ImageList.Add(CTempIconLoader(_T("FOLDERS")));
	m_ImageList.Add(CTempIconLoader(_T("TRANSFER")));

	//advanced:
	m_ImageList.Add(CTempIconLoader(_T("NOTIFICATIONS")));
	m_ImageList.Add(CTempIconLoader(_T("STATISTICS")));
	m_ImageList.Add(CTempIconLoader(_T("MESSAGE")));
	m_ImageList.Add(CTempIconLoader(_T("SECURITY")));
	m_ImageList.Add(CTempIconLoader(_T("SCHEDULER")));
	m_ImageList.Add(CTempIconLoader(_T("WEB")));
	m_ImageList.Add(CTempIconLoader(_T("TWEAK")));	
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_ImageList.Add(CTempIconLoader(_T("PREFERENCES")));
#endif

//==> PPgTabControl [shadow2004]
//	m_ImageList.Add(CTempIconLoader(_T(" ")));	//Extended
//	m_ImageList.Add(CTempIconLoader(_T(" ")));	//HardLimit
//	m_ImageList.Add(CTempIconLoader(_T(" ")));	//V Limit
//	m_ImageList.Add(CTempIconLoader(_T(" ")));	//Drop
//	m_ImageList.Add(CTempIconLoader(_T(" ")));	//IPFilter
//<== PPgTabControl [shadow2004]
//<<< WiZaRd::SlideBar [eMule+]

	SetTitle(RemoveAmbersand(GetResString(IDS_EM_PREFS))); 

	m_wndGeneral.Localize();
	m_wndDisplay.Localize();
	m_wndConnection.Localize();
	m_wndServer.Localize();
	m_wndDirectories.Localize();
	m_wndFiles.Localize();
	m_wndStats.Localize();
	m_wndMessages.Localize();
	m_wndNotify.Localize();
	m_wndSecurity.Localize();
	m_wndTweaks.Localize();
	m_wndWebServer.Localize();
	m_wndScheduler.Localize();

//==> PPgTabControl [shadow2004]
	m_wndDisplay2.Localize();
	m_wndConnection2.Localize();
	m_wndConnection3.Localize();
	m_wndFiles2.Localize();
	m_wndSecurity2.Localize();
//<== PPgTabControl [shadow2004]


//>>> WiZaRd::SlideBar [eMule+]
	m_SlideBar.ResetContent();

	//basics:
	int iGroupNormal = m_SlideBar.AddGroup(GetResString(IDS_LD_BASICOPT));
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_GENERAL), iGroupNormal, PW_GENERAL); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_DISPLAY), iGroupNormal, PW_DISPLAY); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_CONNECTION), iGroupNormal, PW_CONNECTION); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_SERVER), iGroupNormal,PW_SERVER); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_DIR), iGroupNormal, PW_DIRECTORY); 
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_FILES), iGroupNormal, PW_FILES);


	//advanced 
	int iGroupAdvanced = m_SlideBar.AddGroup(GetResString(IDS_LD_ADVANCEDOPT));
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_EKDEV_OPTIONS), iGroupAdvanced, PW_NOTIFY);
	m_SlideBar.AddGroupItem(GetResString(IDS_STATSSETUPINFO), iGroupAdvanced, PW_STATISTIC);
	m_SlideBar.AddGroupItem(GetResString(IDS_MESSAGESCOMMENTS), iGroupAdvanced, PW_MESSAGES);
	m_SlideBar.AddGroupItem(GetResString(IDS_SECURITY), iGroupAdvanced, PW_SECURITY); 
	m_SlideBar.AddGroupItem(GetResString(IDS_SCHEDULER), iGroupAdvanced, PW_SCHEDULER);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_WS), iGroupAdvanced, PW_WEB);
	m_SlideBar.AddGroupItem(GetResString(IDS_PW_TWEAK), iGroupAdvanced, PW_TWEAKS); 

#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	m_SlideBar.AddGroupItem(_T("Debug"), iGroupAdvanced, PW_DEBUG);	
#endif

	int width = m_SlideBar.GetGreaterStringWidth();
	width+=60;

	CRect rectOld;
	m_SlideBar.GetWindowRect(rectOld);

	int xoffset, yoffset;
	if(IsWindowVisible())
	{
		yoffset=0;
		xoffset=width-rectOld.Width();
	}
	else
	{
		xoffset=width-rectOld.Width()+10;
		GetActivePage()->GetWindowRect(rectOld);
		ScreenToClient (rectOld);
		yoffset = -rectOld.top;
	}
	GetWindowRect(rectOld);
	SetWindowPos(NULL,0,0,rectOld.Width()+xoffset,rectOld.Height()+yoffset,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
	CTabCtrl* tab = GetTabControl(); 
	tab->GetWindowRect (rectOld);
	ScreenToClient (rectOld);
	tab->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	CPropertyPage* activepage = GetActivePage();
	activepage->GetWindowRect(rectOld);
	ScreenToClient (rectOld);
	activepage->SetWindowPos(NULL,rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	GetClientRect(rectOld);
	m_SlideBar.SetWindowPos(NULL, 6, 6, width, rectOld.Height() - 12, SWP_NOZORDER | SWP_NOACTIVATE);
	int _PropSheetButtons[] = {IDOK, IDCANCEL, ID_APPLY_NOW, IDHELP };
	CWnd* PropSheetButton;
	for (int i = 0; i < sizeof (_PropSheetButtons) / sizeof(_PropSheetButtons[0]); i++)
	{
		if ((PropSheetButton = GetDlgItem(_PropSheetButtons[i])) != NULL)
		{
			PropSheetButton->GetWindowRect (rectOld);
			ScreenToClient (rectOld);
			PropSheetButton->SetWindowPos (NULL, rectOld.left+xoffset,rectOld.top+yoffset,0,0,SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
		}
	}
	tab->ShowWindow(SW_HIDE);
//>>> WiZaRd::SlideBar [eMule+]
	m_SlideBar.SelectGlobalItem(m_nActiveWnd);
	OnSlideBarSelChanged(NULL, NULL); 
	CenterWindow(); 
//<<< WiZaRd::SlideBar [eMule+]	
}

void CPreferencesDlg::SetStartPage(UINT uStartPageID)
{
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	m_nActiveWnd = uStartPageID;
	//m_pPshStartPage = MAKEINTRESOURCE(uStartPageID);
//<<< shadow2004::Tabbed Prefs [TPT] reworked
}

//==> PPgTabControl [shadow2004]
void CPreferencesDlg::SwitchTab(int Page)
{
	if(m_hWnd && IsWindowVisible())
	{
		CPropertyPage* activepage = GetActivePage();

		if (activepage == &m_wndDisplay || activepage == &m_wndDisplay2)
		{
			StartPageDisplay = Page;
			if (Page == 0)
                        {
				SetActivePage(&m_wndDisplay);
				m_wndDisplay.InitTab(false,0);
			}
			else if (Page == 1)
			{
				SetActivePage(&m_wndDisplay2);
				m_wndDisplay2.InitTab(false,1);
			}
		}

		if (activepage == &m_wndConnection || activepage == &m_wndConnection2 || activepage == &m_wndConnection3)
		{
			StartPageConnection = Page;
			if (Page == 0) 
			{
				SetActivePage(&m_wndConnection);
				m_wndConnection.InitTab(false,0);
			}
			else if (Page == 1)
			{
				SetActivePage(&m_wndConnection2);
				m_wndConnection2.InitTab(false,1);
			}
			else if (Page == 2)
			{
				SetActivePage(&m_wndConnection3);
				m_wndConnection3.InitTab(false,2);
			}
		}

		if (activepage == &m_wndFiles || activepage == &m_wndFiles2)
		{
			StartPageFiles = Page;
			if (Page == 0) 
                        {
				SetActivePage(&m_wndFiles);
				m_wndFiles.InitTab(false,0);
			}
			else if (Page == 1)
			{
				SetActivePage(&m_wndFiles2);
				m_wndFiles2.InitTab(false,1);
			}
		}

		if (activepage == &m_wndSecurity || activepage == &m_wndSecurity2)
		{
			StartPageSecurity = Page;
			if (Page == 0)
                        {
				SetActivePage(&m_wndSecurity);
				m_wndSecurity.InitTab(false,0);
			}
			else if (Page == 1)
			{
				SetActivePage(&m_wndSecurity2);
				m_wndSecurity2.InitTab(false,1);
			}
		}
	}
}
//<== PPgTabControl [shadow2004]
